#!/bin/bash

set_keys() {
PASSWORD=$1
LOGFILE=$2

echo "Install curl and software-properties-common  ..." >> $LOGFILE
echo $PASSWORD | sudo -S apt-get -y install curl software-properties-common apt-transport-https lsb-release gnupg ntpdate

# Installation de nodeJS et pm2
echo "Add nodejs key ..." >> $LOGFILE

#echo $PASSWORD | curl -sL https://deb.nodesource.com/setup_16.x | sudo -S bash -
echo $PASSWORD | sudo -S mkdir -p /etc/apt/keyrings
echo $PASSWORD | curl -fsSL https://deb.nodesource.com/gpgkey/nodesource-repo.gpg.key | sudo -S gpg --dearmor -o /etc/apt/keyrings/nodesource.gpg
echo $PASSWORD | echo "deb [arch=amd64 signed-by=/etc/apt/keyrings/nodesource.gpg] https://deb.nodesource.com/node_16.x nodistro main" | sudo -S tee /etc/apt/sources.list.d/nodesource.list

# Ajout de la clé du repo Cliris
echo "Add Cliris key ..." >> $LOGFILE
echo $PASSWORD | sudo -S wget -q -S -O - https://keys.clirisgroup.com/nexus-pub.key | sudo -S apt-key add - >> $LOGFILE

# Ajout du repo Cliris dans la source list
echo "Add Cliris repo to source list ..." >> $LOGFILE
echo $PASSWORD | sudo -S  add-apt-repository "deb [arch=amd64] https://nexus.clirisgroup.com/repository/ubuntu18.04/ bionic main" >> $LOGFILE

echo "Add Cliris erlang to source list ..." >> $LOGFILE
echo $PASSWORD | curl -1sLf 'https://dl.cloudsmith.io/public/rabbitmq/rabbitmq-erlang/setup.deb.sh' | sudo -E bash

#echo $PASSWORD | curl -fsSL https://packages.erlang-solutions.com/ubuntu/erlang_solutions.asc | sudo -S -H gpg --dearmor -o /etc/apt/trusted.gpg.d/erlang.gpg >> $LOGFILE
#echo $PASSWORD | echo "deb https://packages.erlang-solutions.com/ubuntu $(lsb_release -cs) contrib" | sudo -S tee /etc/apt/sources.list.d/erlang.list >> $LOGFILE

echo "Add Cliris redis to source list ..." >> $LOGFILE
echo $PASSWORD | curl -fsSL https://packages.redis.io/gpg | sudo -S -H gpg --dearmor -o /usr/share/keyrings/redis-archive-keyring.gpg >> $LOGFILE
echo $PASSWORD | echo "deb [signed-by=/usr/share/keyrings/redis-archive-keyring.gpg] https://packages.redis.io/deb $(lsb_release -cs) main" | sudo -S tee /etc/apt/sources.list.d/redis.list >> $LOGFILE

}

update_os() {
PASSWORD=$1
LOGFILE=$2
echo "Launch update and upgrade ..." >> $LOGFILE
echo $PASSWORD | sudo -S apt-get update && DEBIAN_FRONTEND=noninteractive \
               sudo -S apt-get \
                -o Dpkg::Options::='--force-confdef' \
                -o Dpkg::Options::='--force-confold' \
                --force-yes -f -u -y -q dist-upgrade >> $LOGFILE
echo $PASSWORD | sudo -S apt-get upgrade -y >> $LOGFILE

}

install-dependance() {
PASSWORD=$1
LOGFILE=$2
LAUNCHPATH=$3

echo "Install Go langage ..." >> $LOGFILE
curl -O https://storage.googleapis.com/golang/go1.17.8.linux-amd64.tar.gz
echo $PASSWORD | sudo -S tar -C /usr/local -xzf go1.17.8.linux-amd64.tar.gz
echo "export PATH=$PATH:/usr/local/go/bin:$GOPATH/bin" >> ~/.profile
source ~/.profile

echo "Install node js and pm2 ..." >> $LOGFILE
echo $PASSWORD | sudo -S apt-get install -y nodejs >> $LOGFILE
echo $PASSWORD | sudo -S npm install pm2 -g >> $LOGFILE
echo $PASSWORD | sudo -S npm i -g yarn >> $LOGFILE

#Installation de python 
echo "Install ptyhon3 key ..." >> $LOGFILE
echo $PASSWORD | sudo -S apt-get install -y python3-pip >> $LOGFILE

# Installation de ffmpeg 
echo "Install ffmpeg ..." >> $LOGFILE
echo $PASSWORD | sudo -S apt-get -y install ffmpeg >> $LOGFILE

#Installation de redis 
echo "Install redis ..." >> $LOGFILE
echo $PASSWORD | sudo -S apt-get -y install redis-server >> $LOGFILE
echo $PASSWORD | sudo -S apt-get -y install redis >> $LOGFILE


echo "configure redis"
echo "SET password to redis in config file"
echo $PASSWORD | sudo sh -c 'echo "requirepass 0per@ti0n" >> /etc/redis/redis.conf'

echo $PASSWORD | sudo -S chown -R redis:redis /var/log/redis
echo $PASSWORD | sudo -S chmod -R u+rwX,g+rwX,u+rx /var/log/redis

echo $PASSWORD | sudo -S chown redis:redis /etc/redis/redis.conf
echo $PASSWORD | sudo -S chmod u+rw-x,g+r-xw,o+r-xw /etc/redis/redis.conf

echo $PASSWORD | sudo -S systemctl enable redis-server
echo $PASSWORD | sudo -S systemctl restart redis-server.service


#Installation de Rabbit MQ
echo "Install rabbitMQ ..." >> $LOGFILE
echo $PASSWORD | sudo -S apt-get -y install erlang >> $LOGFILE
echo $PASSWORD | curl -s https://packagecloud.io/install/repositories/rabbitmq/rabbitmq-server/script.deb.sh | sudo -S bash >> $LOGFILE
echo $PASSWORD | sudo -S apt-get -y install rabbitmq-server=3.13.1-1 >> $LOGFILE

#Installation de Gstream
echo "Install Gestream ..." >> $LOGFILE
echo $PASSWORD | sudo -S apt-get -y install gstreamer1.0-gl libgstreamer1.0-0 libgstreamer-plugins-bad1.0-0 gstreamer1.0-packagekit gir1.2-gstreamer-1.0 gstreamer1.0-libav  gstreamer1.0-alsa gstreamer1.0-tools gstreamer1.0-plugins* gstreamer1.0-rtsp
}


install-solution-cliris() {

PASSWORD=$1
LOGFILE=$2

# Installation de lsc4
echo "Install lsc4 cpu..." >> $LOGFILE
echo $PASSWORD | sudo -S apt-get install -y lsc4-ubuntu1804-cpu >> $LOGFILE

# Installation des bases de données
echo "Install databases ..." >> $LOGFILE
echo $PASSWORD | sudo -S apt-get install -y tbs4 >> $LOGFILE

# Installation des ETLs 
echo "Install etl ..." >> $LOGFILE
echo $PASSWORD | sudo -S apt-get install -y cs-etl2 >> $LOGFILE

echo $PASSWORD | sudo -S apt-get -f install >> $LOGFILE

# Installation de l’api d’audit 
echo "Install audit api ..." >> $LOGFILE
echo $PASSWORD | sudo -S -i apt-get install -y cs-auditapi >> $LOGFILE

# Installation de SmartAffluence APIs
echo "Install SmartAffluence apis ..." >> $LOGFILE
echo $PASSWORD | sudo -S -i apt-get install -y cs-smartaffluenceapis2 >> $LOGFILE
}

PASSWORD=$1
STEP=$2
LOGFILE=$3
LAUNCHPATH=$4


echo "set log in $LOGFILE"

case $STEP in

  "step1")
  set_keys $PASSWORD $LOGFILE
    ;;

  "step2")
  update_os $PASSWORD $LOGFILE
    ;;

  "step3")
  install-dependance $PASSWORD $LOGFILE $LAUNCHPATH
    ;;

  "step4")
  install-solution-cliris $PASSWORD $LOGFILE
  ;;

  *)
    echo "nothing to do"
    ;;
esac




