#!/bin/bash

PASSWORD=$1

display_msg()
{
    MSG=$1
    echo -e "${MSG}"
}

display_ok()
{
    MSG=$1
    echo -e "${MSG} ... OK"
}

display_nok()
{
    MSG=$1
    echo -e "${MSG} ... NOK"
}

test_directory()
{
    PATHDIRTOTEST=$1
    NAMEDIR=$2

    MSG="${NAMEDIR} is installed"
    [ -d "${PATHDIRTOTEST}" ] && display_ok "${MSG}" || display_nok "${MSG}"
}

test_file()
{
    FILETOTEST=$1
    NAMEFILE=$2

    MSG="${NAMEFILE} is installed"
    [ -f "${FILETOTEST}" ] && display_ok "${MSG}" || display_nok "${MSG}"
}

test_lib()
{
    LIBNAME=$1
    LIBVERSION=$2
    TESTPACKAGE=`dpkg -l | grep ${LIBNAME} | grep ${LIBVERSION}`
    MSG="${LIBNAME} is installed"
    [ -z "$TESTPACKAGE" ] && display_nok "${MSG}" || display_ok "${MSG}"
}

test_package()
{
    PACKAGENAME=$1
    TESTINSTALELED=`dpkg -l | grep ${PACKAGENAME} | awk '{print $3}'`
    [ ! -z "$TESTINSTALELED" ] && display_ok "${PACKAGENAME} package is installed with version $TESTINSTALELED" || display_nok "${PACKAGENAME} package isn't installed"
}

test_service_exist()
{
    SERVICETEST=$1
    TEST=`systemctl list-units --full -all | grep "${SERVICETEST}"`

    if [ ! -z "$TEST" ]; then
        ret=1
     else
        ret=0
        display_msg "${SERVICETEST} is not enabled/installed"
     fi

    return "$ret"
}

test_service_running()
{

    SERVICE=$1
    test_service_exist ${SERVICE}.service
    local res=$?
    
    if [[ $res == 1 ]]; then
        ISRUNNING=`sudo systemctl status ${SERVICE}.service | grep "Active:" | grep "running"`

        MSG="$SERVICE running"
        [ ! -z "$ISRUNNING" ] &&  display_ok "${MSG}" || display_nok "${MSG}"
    fi
}

test_service_active()
{
    SERVICE=$1
    test_service_exist ${SERVICE}.service
    local res=$?

    if [[ $res == 1 ]]; then
        ISRUNNING=`sudo systemctl status ${SERVICE}.service | grep "Active:"`

        MSG="$SERVICE is active"
        [ ! -z "$ISRUNNING" ] &&  display_ok "${MSG}" || display_nok "${MSG}"
    fi
}

test_service_waiting()
{
    SERVICE=$1
    test_service_exist ${SERVICE}.timer
    local res=$?

    if [[ $res == 1 ]]; then
        ISRUNNING=`sudo systemctl status ${SERVICE}.timer | grep "Active:" | grep "waiting"`

        MSG="$SERVICE running"
        [ ! -z "$ISRUNNING" ] &&  display_ok "${MSG}" || display_nok "${MSG}"
    fi
}

test_pm2_service()
{
    SERVICE=$1
    ISRUNNING=`echo $PASSWORD | sudo -S -i pm2 status | grep ${SERVICE} | grep "online"`
    MSG="${SERVICE} Active/waiting"
    [ ! -z "$ISRUNNING" ] && display_ok "${MSG}" || display_nok "${MSG}"
}

test_db()
{
    DBNAME=$1
    QUERYTBS="SELECT count(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '${DBNAME}';"
    DBEXIST=`(echo "$QUERYTBS" ) | mysql -sN -h ${HOST}`
    MSG="${DBNAME} installed"
    [ $DBEXIST -eq 1 ] && display_ok "${MSG}" || display_nok "${MSG}"
}

display_msg "Start Check ... "

#######################################################
display_msg "First step: Check install dependencies ..."
#######################################################

test_directory "/usr/local/lib/libl8w8jwt" "jwt"

test_directory "/usr/local/lib/libtorch" "Torch"

test_directory "/usr/local/lib/opencv" "Opencv"

test_directory "/usr/local/lib/python3.8" "Python"

NODEJS=`node --version`
LISTVER=`echo $NODEJS | tr "." "\n"`
set -- $LISTVER
[ ! -z "$1" ] && display_ok "nodejs installed with version=$1" || display_nok "nodejs installed"


#######################################################
display_msg "Second step: Check install binaries ..."
#######################################################

test_package "lsc"

test_directory "/usr/local/cliris" "cliris directory"
test_file "/usr/local/cliris/bin/LSCnoX" "LSCnoX"
test_file "/usr/local/cliris/bin/CsRemoteWebServer" "CsRemoteWebServer"
test_directory "/usr/local/cs_share" "LSC share data"
test_directory "/usr/local/cs_share/models" "LSC data"

#######################################################
test_package "cs-etl"

test_directory "/usr/local/cs_etl" "cs_etl directory"
test_directory "/usr/local/cs_etl/etl_launcher" "etl_launcher directory"
test_file "/usr/local/cs_etl/etl_launcher/service_launch_etl" "service_launch_etl"

test_directory "/usr/local/cs_etl/etl_aggregation_box" "etl_aggregation_box directory"
test_file "/usr/local/cs_etl/etl_aggregation_box/service_etl_aggregation_minute" "service_etl_aggregation_minute"

#######################################################

test_package "dsdatasync"

test_directory "/usr/local/ds_data_sync" "ds_data_sync directory"
test_file "/usr/local/ds_data_sync/bin/DsDataSync" "DsDataSync"

#######################################################

test_package "cs-auditapi"
test_directory "/usr/local/cs-auditapi" "LSC Audit API"

#######################################################

display_msg  "Third step: Check install databases..."

PASSWORD="cl1r1s"
USER="root"
HOST="localhost"

test_db "to_be_sent"

RESULTU=`(echo "use to_be_sent;"
          echo "SELECT s_num_version from db_version;"
         ) | mysql -sN -h ${HOST}`
         
[ ! -z "$RESULTU" ] && display_ok "version of to_be_sent install with version $RESULTU" || display_nok "version of to_be_sent install"

test_db "to_be_sent_testing"

test_db "archive"

test_db "users_manager"

test_db "cs_admin"

test_db "mafatih"

#######################################################
display_msg "Fourth step: check services is working ..."
#######################################################

test_service_running "ds_datasync"

test_service_running "systemctl_etl_aggregation_box"

test_service_running "systemctl_etl_remontee_donnees"

test_service_running "cs_remoteweb_server"

test_service_running "cs_lsc"

test_service_active "cs_lscstop"

test_service_waiting "cs_lscstop"

test_pm2_service "auditTool"

test_service_running "redis-server"

test_service_running "rabbitmq-server"

test_pm2_service "smartaffluenceadmintoolapi"

test_pm2_service "smartaffluence-alert"

test_pm2_service "smartaffluence-occupation-calcul"

display_msg "Check finished"
