#!/bin/bash

PASSWORD=$1

echo "Start Check ... "

echo -e "First step: Check install dependencies ..."

if [ -d "/usr/local/lib/caffe" ]; then
    echo -e "Caffe install ... OK"
else
    echo -e "Caffe install ... NOK"
fi

if [ -d "/usr/local/lib/libl8w8jwt" ]; then
    echo -e "jwt install ... OK"
else
    echo -e "jwt install ... NOK"
fi

if [ -d "/usr/local/lib/libtorch" ]; then
    echo -e "Torch install ... OK"
else
    echo -e "Torch install ... NOK"
fi

if [ -d "/usr/local/lib/opencv" ]; then
    echo -e "Opencv install ... OK"
else
    echo -e "Opencv install ... NOK"
fi

if [ -d "/usr/local/lib/python3.6" ]; then
    echo -e "Python install ... OK"
else
    echo -e "Python install ... NOK"
fi

NODEJS=`node --version`
LISTVER=$(echo $NODEJS | tr "." "\n")
set -- $LISTVER
if [ "$1" = "v16" ]; then
    echo -e "nodejs install ... OK"
else
    echo -e "nodejs install ... NOK"
fi

echo -e "Second step: Check install binaries ..."

if [ -d "/usr/local/cliris3.22" ]; then
    if [[ ! -f "/usr/local/cliris3.22/bin/LSCnoX" || ! -f "/usr/local/cliris3.22/bin/CsRemoteWebServer" ]]; then
        echo -e "LSC install ... NOK"
    else
        echo -e "LSC install ... OK"
    fi
else
    echo -e "LSC install ... NOK"
fi

if [ -d "/usr/local/cs_share" ]; then
    if [ -d "/usr/local/cs_share/models" ]; then
        echo -e "LSC data install ... OK"
    else
        echo -e "LSC data install ... NOK"
    fi
else
    echo -e "LSC data install ... NOK"
fi

if [ -d "/usr/local/cs_etl/" ]; then
    if [[ -d "/usr/local/cs_etl/etl_launcher" && -f "/usr/local/cs_etl/etl_launcher/service_launch_etl" ]]; then
        echo -e "LSC ETL install ... OK"
    else
        echo -e "LSC ETL install ... NOK"
    fi
    
    if [[ -d "/usr/local/cs_etl/etl_aggregation_box" && -f "/usr/local/cs_etl/etl_aggregation_box/service_etl_aggregation_minute" ]]; then
        echo -e "LSC ETL install ... OK"
    else
        echo -e "LSC ETL install ... NOK"
    fi
else
    echo -e "LSC ETL install ... NOK"
fi

if [ -d "/usr/local/AuditAPI" ]; then
    echo -e "LSC Audit API install ... OK"
else
    echo -e "LSC Audit API install ... NOK"
fi

echo -e "Third step: Check install databases ..."

PASSWORD="cl1r1s"
USER="root"
HOST="localhost"

QUERYTBS="SELECT count(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'to_be_sent';"
DBEXIST=`(echo "$QUERYTBS" ) | mysql -sN -h ${HOST}`
if [ $DBEXIST -eq 1 ]; then
    echo -e "to_be_sent install ... OK"
else
    echo -e "to_be_sent install ... NOK"
fi
QUERYTBSTEST="SELECT count(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'to_be_sent_testing';"
DBEXIST=`(echo "$QUERYTBSTEST" ) | mysql -sN -h ${HOST}`
if [ $DBEXIST -eq 1 ]; then
    echo -e "to_be_sent_testing install ... OK"
else
    echo -e "to_be_sent_testing install ... NOK"
fi
QUERYARCHIVE="SELECT count(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'archive';"
DBEXIST=`(echo "$QUERYARCHIVE" ) | mysql -sN -h ${HOST}`
if [ $DBEXIST -eq 1 ]; then
    echo -e "archive install ... OK"
else
    echo -e "archive install ... NOK"
fi
QUERYUSERS="SELECT count(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'users_manager';"
DBEXIST=`(echo "$QUERYUSERS" ) | mysql -sN -h ${HOST}`
if [ $DBEXIST -eq 1 ]; then
    echo -e "users_manager install ... OK"
else
    echo -e "users_manager install ... NOK"
fi
QUERYADMIN="SELECT count(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'cs_admin';"
DBEXIST=`(echo "$QUERYADMIN" ) | mysql -sN -h ${HOST}`
if [ $DBEXIST -eq 1 ]; then
    echo -e "cs_admin install ... OK"
else
    echo -e "cs_admin install ... NOK"
fi
QUERYKEY="SELECT count(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'mafatih';"
DBEXIST=`(echo "$QUERYKEY" ) | mysql -sN -h ${HOST}`
if [ $DBEXIST -eq 1 ]; then
    echo -e "mafatih install ... OK"
else
    echo -e "mafatih install ... NOK"
fi

QUERYOCC="SELECT count(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'agregation_occupation';"
DBEXIST=`(echo "$QUERYOCC" ) | mysql -sN -h ${HOST}`
if [ $DBEXIST -eq 1 ]; then
    echo -e "agregation_occupation install ... OK"
else
    echo -e "agregation_occupation install ... NOK"
fi

echo -e "Fourth step: check services working is ..."

ISRUNNING=`echo $PASSWORD | sudo -S systemctl status systemctl_etl_aggregation_box.service | grep "Active:" | grep "running"`
if [[ ! -z $ISRUNNING ]]; then
    echo -e "etl_aggregation_box running ... OK"
else
    echo -e "etl_aggregation_box running ... NOK"
fi
ISRUNNING=`echo $PASSWORD | sudo -S systemctl status systemctl_etl_remontee_donnees.service | grep "Active:" | grep "running"`
if [[ ! -z $ISRUNNING ]]; then
    echo -e "etl_remontee_donnees running ... OK"
else
    echo -e "etl_remontee_donnees running ... NOK"
fi
ISRUNNING=`echo $PASSWORD | sudo -S systemctl status cs_remoteweb_server.service | grep "Active:" | grep "running"`
if [[ ! -z $ISRUNNING ]]; then
    echo -e "remoteweb_server running ... OK"
else
    echo -e "remoteweb_server running ... NOK"
fi

ISRUNNING=`echo $PASSWORD | sudo -S systemctl status cs_lscinit.timer | grep "Active:" | grep "running"`
if [[ -z $ISRUNNING ]]; then
    echo -e "cs_lscinit running ... OK"
else
    echo -e "cs_lscinit running ... NOK"
fi

ISRUNNING=`echo $PASSWORD | sudo -S -i pm2 status | grep auditTool | grep "online"`
if [[ ! -z "$ISRUNNING" ]]; then
    echo -e "auditTool running ... OK"
else
    echo -e "auditTool running ... NOK"
fi

ISRUNNING=`echo $PASSWORD | sudo -S systemctl status redis-server.service | grep "Active:" | grep "running"`
if [[ ! -z $ISRUNNING ]]; then
    echo -e "redis-server running ... OK"
else
    echo -e "redis-server running ... NOK"
fi

ISRUNNING=`echo $PASSWORD | sudo -S systemctl status rabbitmq-server.service | grep "Active:" | grep "running"`
if [[ ! -z $ISRUNNING ]]; then
    echo -e "rabbitmq-server.service running ... OK"
else
    echo -e "rabbitmq-server.service running ... NOK"
fi

ISRUNNING=`echo $PASSWORD | sudo -S -i pm2 status | grep smartaffluenceadmintoolapi | grep "online"`
if [[ ! -z "$ISRUNNING" ]]; then
    echo -e "smartaffluenceadmintoolapi running ... OK"
else
    echo -e "smartaffluenceadmintoolapi running ... NOK"
fi

ISRUNNING=`echo $PASSWORD | sudo -S -i pm2 status | grep smartaffluence-alert  | grep "online"`
if [[ ! -z "$ISRUNNING" ]]; then
    echo -e "smartaffluence-alert  running ... OK"
else
    echo -e "smartaffluence-alert  running ... NOK"
fi

ISRUNNING=`echo $PASSWORD | sudo -S -i pm2 status | grep smartaffluence-occupation-calcul  | grep "online"`
if [[ ! -z "$ISRUNNING" ]]; then
    echo -e "smartaffluence-occupation-calcul  running ... OK"
else
    echo -e "smartaffluence-occupation-calcul  running ... NOK"
fi

echo -e "Check finished"
